#include <cstdio>
#include <vector>
#include <utility>
#include <algorithm>

using namespace std;

const int MAXN = 2010;

int component = 0;
char a[MAXN][MAXN];
int in_component[MAXN][MAXN];
int r, s;
const int DY[] = {0, 0, 1, -1};
const int DX[] = {1, -1, 0, 0};
int last_counted[MAXN * MAXN];
int component_size[MAXN * MAXN];

int dfs(int y, int x) {
  if (y < 0 || x < 0 || y >= r || x >= s) return 0;
  if (in_component[y][x]) return 0;
  if (a[y][x] == '0') return 0;
  in_component[y][x] = component;
  int ret = 0;
  for (int i = 0; i < 4; ++i) {
    ret += dfs(y + DY[i], x + DX[i]);
  }
  return ret + 1;
}

int main() {
  scanf("%d%d", &r, &s);
  for (int i = 0; i < r; ++i) {
    scanf("%s", a[i]);
  }

  for (int i = 0; i < r; ++i) {
    for (int j = 0; j < s; ++j) {
      if (in_component[i][j] || a[i][j] != '1') continue;
      ++component;
      component_size[component] = dfs(i, j);
    }
  }

  int cookie = 0;
  auto count_on_diag = [&](int y, int x, int dy, int dx) {
    ++cookie;
    int cnt = 0;
    auto check_component = [&](int y, int x) {
      if (y >= 0 && y < r && x >= 0 && x < s) {
        int comp = in_component[y][x];
        if (!comp) return;
        if (last_counted[comp] != cookie) {
          last_counted[comp] = cookie;
          cnt += component_size[comp];
        }
      }
    };
    while (y >= 0 && y < r && x >= 0 && x < s) {
      int comp = in_component[y][x];
      if (a[y][x] != '1') {
        cnt++;
      }
      check_component(y, x);
      for (int i = 0; i < 4; ++i) {
        check_component(y + DY[i], x + DX[i]);
      }
      y += dy;
      x += dx;
    }
    return cnt;
  };

  int best = 0;
  // smjer gore lijevo prema dolje desno pocevsi iz prvog stupca
  for (int i = 0; i < r; ++i) {
    best = max(best, count_on_diag(i, 0, 1, 1));
  }
  // smjer gore lijevo prema dolje desno pocevsi iz prvog retka
  for (int i = 0; i < s; ++i) {
    best = max(best, count_on_diag(0, i, 1, 1));
  }
  // smjer gore desno prema dolje lijevo pocevsi iz zadnjeg stupca
  for (int i = 0; i < r; ++i) {
    best = max(best, count_on_diag(i, s - 1, 1, -1));
  }
  // smjer gore desno prema dolje lijevo pocevsi iz prvog retka
  for (int i = 0; i < s; ++i) {
    best = max(best, count_on_diag(0, i, 1, -1));
  }

  printf("%d\n", best);
  return 0;
}
